def max_power(n, p):
    # Сума всіх потужностей дронів
    total_power = sum(p)
    
    # Змінна для збереження максимального значення потужності
    max_power = total_power
    
    # Перебір пар (l, r)
    for l in range(n):
        for r in range(l + 1, n):
            # Для кожної пари (l, r) обчислюємо можливі варіанти x
            max_x = (r - l) // 2  # максимальний x, щоб між частинами завіси був хоча б один дрон
            for x in range(1, max_x + 1):
                # Потужність прихованих дронів
                hidden_left = sum(p[l:l + x])  # Потужність для лівої частини
                hidden_right = sum(p[r - x + 1:r + 1])  # Потужність для правої частини
                
                # Потужність виставки без прихованих дронів
                current_power = total_power - hidden_left - hidden_right
                
                # Оновлюємо максимальну потужність
                max_power = max(max_power, current_power)
    
    return max_power

# Вхідні дані
n = int(input())  # довжина масиву
p = list(map(int, input().split()))  # масив потужностей дронів

# Виведення результату
print(max_power(n, p))